/* TAPE/PVM %W% %G% */

#include <sys/time.h>

#include "pvm3.h"

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"
#include "tape_classes.h"
#include "tape_tags.h"

#define masc_pvm classe_syst

int Tpvm_addhosts(int numfile,int numline,int masc,char **names,int count,int *svp )
{
int ret;
struct timeval tp;
int i,buf,oldbuf,sa=0;

if(pvm_actif)
{
tape_clock(&tp);

ret=pvm_addhosts (names,count,svp);
if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
   tape_event(event_addhosts,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	      "%d %d",ret,count);

 /* count the number of successful adds */ 
for(i=0;i<count;i++)
 if(svp[i]>=0)
  sa++;

 /* notify tape_control about successful adds */
buf=pvm_mkbuf(PvmDataDefault);
oldbuf=pvm_setsbuf(buf);
pvm_pkint(&sa,1,1);
for(i=0;i<count;i++)
 if(svp[i]>=0)
   pvm_pkstr(names[i]);
pvm_send(control,msgtag_addhost);
pvm_freebuf(buf);
pvm_setsbuf(oldbuf);

return ret;
}
else return 0;
}

/* 
int Tpvm_advise( int numfile, int numline, int masc,int what)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret=pvm_advise (what);

  tape_event(event_advise,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,what);
}
else
  ret=pvm_advise (what);

return ret;
}
*/


int Tpvm_delhosts(int numfile,int numline,int masc,char **hosts,int nhost,int *infos )
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect))
   {
   struct tableau *tab;

   tape_clock(&tp);
   ret=pvm_delhosts(hosts,nhost,infos);

   tab->num=nhost;
   tab->tab=infos;
   tape_event(event_delhosts,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	      "%d %d %d",ret,nhost,tab);
   }
else
  ret=pvm_delhosts(hosts,nhost,infos);

return ret;
}

int Tpvm_tidtohost(int numfile,int numline,int masc,int tid)
{
int ret;
struct timeval tp;

if((masc&(mselect>>nb_classe))&&(masc_pvm&mselect)) {

  tape_clock(&tp);
  ret = pvm_tidtohost(tid);

  tape_event(event_tidtohost,taskid,numfile,numline,tp.tv_sec-base_s,tp.tv_usec,
	     "%d %d",ret,tid);
}
else
  ret = pvm_tidtohost(tid);

return ret;
}

