/* TAPE/PVM %W% %G% */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "classe.h"

/* default window size for smoothing of clock samples */
#define DEFAULT_WSIZE   5

int param_supl;
void tape_init(int max_buf,int nb_phase, int masq_param, int control_param, int base_param,int nb_pingpong_param,double temps_attente_param, int window_size);

int analyse_arg(int *argc,char** argv,int taille_buf_defaut,
			int nb_phase_defaut,int my_delay,
                        int nb_pingpong_defaut)
{
   int i,j,k,ret;
   int my_argc;
   double temps_attente_defaut;
   char flag_debparam,flag_masque,flag_taillebf,flag_nbphase,flag_control,flag_base;
   char flag_pingpong,flag_temps_attente, flag_wsize;
   char *param,chaine[40];
   char partie_entiere[10],partie_decimale[10];
   int diviseur;
   int max_buf,masque_param,control_param,base_param,nb_phase,nb_pingpong_param;
   double temps_attente_param;
   int wsize=DEFAULT_WSIZE;

   flag_debparam=0;
   flag_taillebf=0;
   flag_nbphase=0;
   flag_control=0;
   flag_base=0;
   flag_masque=0;
   flag_pingpong=0;
   flag_wsize=0;
   flag_temps_attente=0;
   ret=1;
   
   /* valeurs par defaut (certaines proviennent de tapepp */

   max_buf=taille_buf_defaut;
   nb_phase=nb_phase_defaut;
   nb_pingpong_param=nb_pingpong_defaut;
   temps_attente_defaut=(double)my_delay;
   temps_attente_param=temps_attente_defaut;
   masque_param=all_modules | classe_control | classe_msg |
                classe_info | classe_syst    | classe_group;

   control_param=0;
   base_param=0;
   param_supl=0;

   if(argc==NULL)
     my_argc=0;
   else
     my_argc=*argc;

   for(i=1;i<my_argc;i++)
      {
      param=(char *)malloc(40);
      strcpy(param,argv[i]);
      if (param[0]=='-')
         {
         switch (param[1])
            {
	    case 'P': /* nombre de phases */
	       argv[i]=0;
               if (flag_nbphase)
                  ret=0;
               else
                  {
                  strcpy(chaine,param);
                  nb_phase=atoi(chaine+2);
                  param_supl++;
                  flag_nbphase++;
                  flag_debparam++;
		  }
               break;

	    case 'T': /* taille ds buffers */
	       argv[i]=0;
               if (flag_taillebf)
                  ret=0;
               else
                  {
                  strcpy(chaine,param);
                  max_buf=atoi(chaine+2);
                  param_supl++;
                  flag_taillebf++;
                  flag_debparam++;
		  }
               break;

            case 'M': /* masque de selection */
	       argv[i]=0;
               if (flag_masque)
                  ret=0;
               else
                  {
                  strcpy(chaine,param);
                  sscanf(chaine+2,"%x",&masque_param);
                  /* masque_param=atoi(chaine+2); */
                  param_supl++;
                  flag_masque++;
                  flag_debparam++;
		  }
               break;

            case 'C': /*s'il s'agit d'un code esclave, le taskid du control */
                      /* absolu est passe dans les arguments */
	       argv[i]=0;
               if (flag_control)
                  ret=0;
               else
                  {
                  strcpy(chaine,param);
                  control_param=atoi(chaine+2);
                  param_supl++;
                  flag_control++;
                  flag_debparam++;
		  }
               break;  

            case 'B': /*s'il s'agit d'un code esclave, la base de temps */
                      /* absolue est passe dans les arguments */
	       argv[i]=0;
               if (flag_base)
                  ret=0;
               else
                  {
                  strcpy(chaine,param);
                  base_param=atoi(chaine+2);
                  param_supl++;
                  flag_base++;
                  flag_debparam++;
                  }
               break; 

	    case 'A': /* temps d'attente entre deux envois de messages */
	       argv[i]=0;
               if (flag_temps_attente)
                  ret=0;
               else
                  {
                  strcpy(chaine,param);
                  k=0;
                  while ((chaine[k+2]!='.')&&(chaine[k+2]!=0))
                       { partie_entiere[k]=chaine[k+2];
                         k++;
                       }
                  partie_entiere[k]=0;
                  temps_attente_param=(double) atoi(partie_entiere);
                  if (chaine[k+2]=='.')
                     { k++;j=0;
                       diviseur=1;
                       while (chaine[k+2]!=0)
                         {partie_decimale[j]=chaine[k+2];
                          k++;j++;
                          diviseur=diviseur*10;
                          }
                     partie_decimale[j]=0;
                     temps_attente_param+=((double)atoi(partie_decimale))/diviseur; 
                     }
                  param_supl++;
                  flag_temps_attente++;
                  flag_debparam++;
		  }
               break;

	    case 'E': /* nombre d'echange */
	       argv[i]=0;
               if (flag_pingpong)
                  ret=0;
               else
                  {
                  int nbpp;
                  strcpy(chaine,param);
                  nbpp=atoi(chaine+2);
                  if(nbpp>0) nb_pingpong_param=nbpp;
                  param_supl++;
                  flag_pingpong++;
                  flag_debparam++;
		  }
               break;
	     case 'W': /* size of window for smoothing */
               argv[i]=0;
               if(flag_wsize)
                 ret=0;
               else {
                 int wsize_param;
                 strcpy(chaine,param);
                 wsize_param=atoi(chaine+2);
                 wsize=(wsize_param>0 ? wsize_param : DEFAULT_WSIZE);
                 param_supl++;
                 flag_wsize++;
                 flag_debparam++;
	       }
               break;
	    default:
		 ret=0;
	    }
         }
      else
	 if (flag_debparam)
	    ret=0;
      }
   if (ret) {
     if(argc!=NULL)
      *argc-=param_supl;
   }
   else
     param_supl=0;

   if(pvm_parent()<=0) {
     /* only the master prints welcome message */

     printf("[tape] TAPE/PVM (c) 1994 by E.Maillet, LMC-IMAG, Grenoble, France.\n");
     printf("[tape] Runtime parameters : ");
     printf("T %d ",max_buf);
     printf("P %d ",nb_phase);
     printf("M %x ",masque_param);
     /* printf("C %d ",control_param); */
     /* printf("B %d ",base_param); */
     printf("A %.1f ",temps_attente_param);
     printf("E %d ",nb_pingpong_param);
     printf("W %d\n\n", wsize);
     /* printf("argc:%d\n\n",*argc); */
   }

   tape_init(max_buf,nb_phase,masque_param,control_param,base_param,
             nb_pingpong_param,temps_attente_param,wsize);
   return ret;
}
