/* TAPE/PVM %W% %G% */

#include <stdio.h>
#include <string.h>

int compactage (char *entree,char *buffer)
/* compactage d'une chaine de caracteres compposee de chiffres, de '/' et de ';'
		'/' est un separateur de champs
		';' est un separateur d'evenements
   buffer est l'adresse du dernier caractere compacte deja stocke
   resultat: nombre de caracteres ecrits dans le buffer
*/
{
char car_cour;
char indice;	/* booleen indiquant si on travaille sur le demi-octet haut */
int i;		/* i est l'indice du dernier caractere du buffer */
int j;		/* j est l'indice du caractere courant de la chaine d'entree */

i=0;
indice=0;
if(buffer[0])	/* 1er caractere du buffer est nul=>le buffer est vide */
   {
   if((char)(buffer[0]<<4))
      i=1;	/* 1er caractere du buffer totalement occupe */
   else
      indice=1;	/* demi-octet bas du 1er caractere du buffer libre */
   }

for (j=0;j<strlen(entree);j++)
   {
   car_cour=(char)(entree[j]-',')&0xf;
   if (indice)
      {		/* on ecrit dans le demi-octet du bas */
      buffer[i] &= 0xf0; 
      buffer[i++] |= car_cour; 
      indice = 0;
      }
   else
      {		/* on ecrit dans le demi-octet du haut */
      buffer[i] = (char)(car_cour<<4) ;
      indice++;
      }
   if(entree[j]=='/')	/*debut de chaine de caracteres */
      {
      if(indice)	/* on debute sur l'octet suivant */
	 {
	 indice=0;
	 i++;
	 }
      while(entree[++j]!='/'||entree[j+1]=='/')
	 {
	 buffer[i++]=entree[j];
	 if(entree[j]=='/')
	    buffer[i++]=entree[++j];
	 }
      buffer[i++]='/';
      }
   }
if(! indice)	/* i pointe sur le dernier caractere non vide de buffer */
   i--;
return i;
}

