/* TAPE/PVM %W% %G% */

#include <stdio.h>

#include "tape_globals.h"
#include "tape.h"

/* transform a local date (sec,usec) into a global date */
 
void date_absolue(double a,double b,int *date_s,int *date_ms,int end_sba1)

/* a,b: estimated drift and offset coefficients
   date_s, date_ms: the local date to be transformed
*/

{
double date_totale,date_totale_absolue;
int i,j;

/* local event date -> double */
date_totale=(double) *date_s;
date_totale+=((double) *date_ms)/1000000.0;
 
/* compute global event date (relative to base_s) */
date_totale_absolue=(date_totale - b)/a;

/* global event date -> (int,int) (relative to end_sba1) */
*date_s=(int)date_totale_absolue;
*date_ms=(int)((date_totale_absolue-*date_s)*1e6);
(*date_s)-=(end_sba1-base_s);

}
