/* TAPE/PVM %W% %G% */

#include <sys/time.h>
#include <stdio.h>
#include "pvm3.h"

#include "tape.h"
#include "tapetask_globals.h"
#include "tape_tags.h"
#include "insert.h"

void usleep(unsigned useconds);


void horloge_reference(struct res_somme **table_machine,int nbh,int nb_ping_pong,
		       int temps_attente, int wsize)

/* table_machine : table with (pointers to) per-machine clock statistics
   nbh           : number of machines (i.e. size of the table)
   nb_ping_pong  : number of message exchanges
   temps_attente : delay in s between 2 successive exchanges
   wsize         : size of smoothing window
*/

{
int i,j;
double X_double,delta_double,Y_double;
double debut_double;
struct timeval X1,X2,debut;
int Y1_s,Y1_ms;
int delta_s,delta_ms;
int sec,usec;
struct point p;

/* echange de dates entre le host de reference et les autres */
for (i=0;i<nb_ping_pong+wsize-1;i++)
  { 
  for (j=0;j<nbh;j++)
     {
      if (table_machine[j]->dtid != htid)
         {
         tape_clock(&debut);
         debut_double=(double)debut.tv_sec;
         debut_double+=((double)debut.tv_usec)/1000000.0;
         pvm_initsend(PvmDataDefault);
         tape_clock(&X1);
	 sec=X1.tv_sec;
	 usec=X1.tv_usec;
         pvm_pkint(&sec,1,1);
         pvm_pkint(&usec,1,1);
         pvm_send(table_machine[j]->ttid,msgtag_horl);
         pvm_recv(table_machine[j]->ttid,msgtag_horl);
         tape_clock(&X2);
         pvm_upkint(&Y1_s,1,1);
         pvm_upkint(&Y1_ms,1,1);

         /* transformation des deux int en un double */
         /* transformation de X en double */
         X_double=(double)(X2.tv_sec-base_s);
         X_double+=((double)X2.tv_usec)/1000000.0;
         /* calcul de delta sous forme d'un double */
         delta_s=X2.tv_sec - X1.tv_sec;
         if ((X2.tv_usec - X1.tv_usec) < 0)
            { delta_s--;
              delta_ms = 1000000 + X2.tv_usec -X1.tv_usec ;
            }
         else
            { delta_ms = X2.tv_usec - X1.tv_usec;
            }
         delta_double=(double)delta_s;
         delta_double+=((double)delta_ms)/1000000.0;
         /* transformation de Y en double */
         Y_double=(double)(Y1_s-base_s);
         Y_double+=((double)Y1_ms)/1000000.0;
         Y_double+=delta_double/2.0;

         /* construct the new sample point */
         p.X=X_double;
         p.Y=Y_double;

         /* smooth the sample by the running median method */
         /* (cf. functions in insert.c)                    */

         if(i<wsize) /* window is not full yet */
            insert_sort(wsize,
                        table_machine[j]->win,
                        table_machine[j]->rnk,
                        p,i);
         else
           insert_point(wsize,       
                        table_machine[j]->win,
                        table_machine[j]->rnk,
                        p);
         if(i>=wsize-1) {
            get_median_point(wsize,table_machine[j]->win,&p);
            /* add median point to statistics */
            table_machine[j]->SX+=p.X;
            table_machine[j]->SY+=p.Y;
            table_machine[j]->SXY+=p.X*p.Y;
            table_machine[j]->SXX+=p.X*p.X; 
            table_machine[j]->SYY+=p.Y*p.Y;
         }     
       }
    }
  usleep(temps_attente*1000000);
  }
}


