/* TAPE/PVM %W% %G% */

#include <stdio.h>

#include "tape.h"
#include "tape_tags.h"
#include "tape_globals.h"

#include "pvm3.h"

int unlink(char *path);

/*************************************************************
 *
 * - inform tape_control that I want to finish tracing
 * - wait for permission from tape_control to send my buffers
 * - send my buffers
 *
 *************************************************************/

void fin_trace()
{
int i, old_buf, new_buf;
FILE *F;

if(pvm_actif)
  {

	/* notification a la tache control */
   new_buf=pvm_mkbuf(0);
   old_buf=pvm_setsbuf(new_buf);

   pvm_send(control,msgtag_exit);
   pvm_recv(control,msgtag_control);

   pvm_freebuf(new_buf);

		/* envoi du nombre de buffers */
   new_buf=pvm_mkbuf(0);
   pvm_setsbuf(new_buf);

   pvm_pkint(&nb_buffer,1,1);
   pvm_send(control,msgtag_nbuf);

   pvm_freebuf(new_buf);

		/* envoi du dernier buffer */

   new_buf=pvm_mkbuf(0);
   pvm_setsbuf(new_buf);

   buffer[buffer_index+1]=0;
   pvm_pkstr(buffer);
   pvm_send(control,msgtag_buf+nb_buffer);

   pvm_freebuf(new_buf);

                /* envoi des buffers */
   if(nb_buffer>1) 
      {
      F=fopen(file_name,"r");
      for(i=1;i<nb_buffer;i++)
         {
         new_buf=pvm_mkbuf(0);
	 pvm_setsbuf(new_buf);

         fread(buffer,buffer_size,1,F);
         pvm_pkstr(buffer);
         pvm_send(control,msgtag_buf+i);

	 pvm_freebuf(new_buf);
         }
      fclose(F);
      }

   /* sprintf(com_sys,"rm %s",file_name); */
   /* system(com_sys); */
   unlink(file_name);
   pvm_actif=0;

   pvm_setsbuf(old_buf);
 }
}

