/* TAPE/PVM %W% %G% */

#include <sys/time.h>
#include <stdlib.h>
#include "pvm3.h"
#include "independant.h"

#define MAXARGLEN 20  /* max. length of tape arg */

/* addTapeArgs builds a new argument vector by
 * appending the Tape-specific arguments to the
 * user's arguments 'argv'. '*argc' contains the
 * number of entries in the new vector. The new
 * vector is returned. It has to be freed by the
 * caller.
 */

 char** addTapeArgs(int *argc,char** argv)
{
  char **new_argv,*tapearg;
  int k;

  *argc=0;
  if(argv)
    while(argv[*argc]) 
      (*argc)++;
  if(!(new_argv=calloc(*argc+6,sizeof(char*))))
    fatalMallocFailure(__FILE__,__LINE__);
  for(k=0;k<*argc;k++)
    new_argv[k]=argv[k];

  if(!(tapearg=(char*)malloc(MAXARGLEN)))
    fatalMallocFailure(__FILE__,__LINE__);
  sprintf(tapearg,"-P%d",max_phase);
  new_argv[(*argc)++]=tapearg;

  if(!(tapearg=(char*)malloc(MAXARGLEN)))
    fatalMallocFailure(__FILE__,__LINE__);
  sprintf(tapearg,"-T%d",taille_buf);
  new_argv[(*argc)++]=tapearg;

  if(!(tapearg=(char*)malloc(MAXARGLEN)))
    fatalMallocFailure(__FILE__,__LINE__);
  sprintf(tapearg,"-M%x",mselect);
  new_argv[(*argc)++]=tapearg;

  if(!(tapearg=(char*)malloc(MAXARGLEN)))
    fatalMallocFailure(__FILE__,__LINE__);
  sprintf(tapearg,"-C%d",control);
  new_argv[(*argc)++]=tapearg;

  if(!(tapearg=(char*)malloc(MAXARGLEN)))
    fatalMallocFailure(__FILE__,__LINE__);
  sprintf(tapearg,"-B%ld",base_s);
  new_argv[(*argc)++]=tapearg;

  new_argv[*argc]=0;
  return(new_argv);
}

/* removeTapeArgs frees memory allocated by addTapeArgs */

void removeTapeArgs(int argc, char **new_argv)
{
  int k;
  for(k=argc-5;k<argc;k++)
    free(new_argv[k]);
  free(new_argv);
}
