/* TAPE/PVM %W% %G% */

#include <stdio.h>
#include <sys/time.h>
#include <string.h>
#include <stdarg.h>
#include <memory.h>

#include "tape.h"
#include "tape_globals.h"
#include "tape_events.h"

#define MFL   80   /* maximum length of a % format */
#define MEL 1000   /* maximum event length */



/* tape_event is a wrapper for tape_v_event. This introduces some
   overhead but gives more flexibility. Users can define other wrapper
   functions which provide automatic dating for instance. Wrapper functions
   initialize the event header (first 6 ints), and pass control to tape_v_event 
   which does the actual event formatting.
 */

void
tape_event(int evtId,
	   int genId,
	   int fileId,
	   int lineNo,
	   int sec,
	   int usec,
	   char *format,
	   ...)
{
  va_list ap;
  va_start(ap,format);

  tape_v_event(evtId,genId,fileId,lineNo,sec,usec,format,ap);

  va_end(ap);
}



/* main event formating function */

void 
tape_v_event(int evtId,
	     int genId,
	     int fileId,
	     int lineNo,
	     int sec,
	     int usec,
	     char *format,
	     va_list ap)

/* stores event into local event buffer and flushes buffer if necessary

        pre   : ap is a va list initialized to a list of args whose
                format is described by 'format'
           
        ints  : form the constant header of event

	format:	variables	%d	integer
				%f	float (6 digits after point)
				%.nf	float (n digits after point)
				%t	table of integers
				%s	string
		NULL            no variable arg list

	args:	int
		double
		double
		(struct tableau *)
		char *
*/

{
int i,j,k,n;
char chaine[MEL];   /* the event is constructed in chaine ("$1:$2:...:$n;") */
char pval[MFL];     /* single formats are built in pval before being */
                    /* appended to chaine */
struct tableau *ptr;
int longueur;       /* current event length */

chaine[0]=0;

  /* format constant part of arg list */
sprintf(chaine,"%d",evtId);
longueur=strlen(chaine);

sprintf(pval,"%d",genId);
strcat(strcat(chaine,":"),pval);
longueur+=strlen(pval)+1;

sprintf(pval,"%d",fileId);
strcat(strcat(chaine,":"),pval);
longueur+=strlen(pval)+1;

sprintf(pval,"%d",lineNo);
strcat(strcat(chaine,":"),pval);
longueur+=strlen(pval)+1;

sprintf(pval,"%d",sec);
strcat(strcat(chaine,":"),pval);
longueur+=strlen(pval)+1;

sprintf(pval,"%d",usec);
strcat(strcat(chaine,":"),pval);
longueur+=strlen(pval)+1;

  /* skip variable part in case no format string is given */
if( format==NULL || strlen(format)==0 )
  goto end_vararg;

strcat(chaine,":");
longueur++;

  /* format variable part of arg list */

  /* read event format */
for(i=0;i<strlen(format);i++)
   {
   pval[0]=0;
   if(format[i]=='%')
      {		/* prefixe pour une variable */
      switch (format[++i])
         {
	 case 'd':
	 sprintf(pval,"%d",va_arg(ap,int));
	 longueur+=strlen(pval);
	 strcat(chaine,pval);
	/* on concatene a la chaine l'entier en ASCII */
	 break;
	 case 't':
	 ptr=(struct tableau *)va_arg(ap,int*);
	 for(j=0;j<ptr->num-1;j++)
	    {
	    sprintf(pval,"%d:",ptr->tab[j]);
	    longueur+=strlen(pval);
	    strcat(chaine,pval);
	    }
	 sprintf(pval,"%d",ptr->tab[j]);
	 longueur+=strlen(pval);
	 strcat(chaine,pval);
	/* on concatene a la chaine les entiers en ASCII */
	 break;
	 case '.':
	 n=0;
	 while(format[++i]>'/'&&format[i]<':')
	    n=n*10+format[i]-'0';
	 if (format[i]!='f')
	    printf("Erreur de format\n");
	 sprintf(pval,"%.*f",n,va_arg(ap,double));
	 longueur+=strlen(pval);
	 strcat(chaine,pval);
	/* on concatene a la chaine le reel en ASCII */
	 break;
	 case 'f':
	 sprintf(pval,"%f",va_arg(ap,double));
	 longueur+=strlen(pval);
	 strcat(chaine,pval);
	/* on concatene a la chaine le reel en ASCII */
	 break;
	 case 's':
	 sprintf(pval,"%s",va_arg(ap,char *));
	 longueur+=2;
	 strcat(chaine,"/");
	 for(k=0;k<strlen(pval);k++)
	    {
	    if(pval[k]=='/')
	       {
		 longueur+=2;
		 strcat(chaine,"/");
	       }
	    longueur+=2;
	    strncat(chaine,pval+k,1);
	    }
	 longueur+=2;
	 strcat(chaine,"/");
	 break;
	 default:
	 printf("Erreur de format\n");
	 }
      }
   else
      {		/* sinon on propage les separateurs */
      if (format[i]==' ')
	 {
longueur++;
	 strcat(chaine,":");
	 }
      }
   }

end_vararg: longueur++;
strcat(chaine,";");

/* Event format finished (constant and variable part).
 * 'chaine' contains a string of the following form:
 *
 *               "$1:$2:..:$n;"
 *
 * where the $i are the event's fields, ":" is the field
 * separator and ";" is the end marker. n>=6 (n=6 in case
 * no format was given)
 */

#ifdef DEBUG
printf("%s\n",chaine);
#endif

if(buffer_index+(longueur+1)/2>buffer_size-2)
   {		/* surcharge du buffer=>on stocke dans un fichier temporaire
			et local */
   struct timeval debut,fin;
   long int dif_s,dif_us;
   FILE *F;

   tape_clock(&debut);

   while(++buffer_index<buffer_size)
      buffer[buffer_index]=0;
   if(!(F=fopen(file_name,"a"))) {
     fprintf(stderr,"tape warning, cannot open local trace file, buffer lost.\n");
     fflush(stderr); }
   else {
     fwrite(buffer,buffer_size,1,F);
     fclose(F);	/* sauvegarde dans le temporaire local */
     nb_buffer++;
   }
   if(longueur>buffer_size-2) {
     fprintf(stderr,"tape warning, event is longer than buffer size, event lost.\n");
     fflush(stderr); }
   else {
     buffer[0]=0;	/* reinitialisation du buffer */
     buffer_index=compactage(chaine,buffer);
   }
   tape_clock(&fin);
   dif_s=fin.tv_sec-debut.tv_sec;
   dif_us=fin.tv_usec-debut.tv_usec;
   if(dif_us<0)
      {
      dif_us+=1000000;
      dif_s--;
      }
   sprintf(chaine,"%d:%d:%ld:%ld:%ld:%ld;",event_trace,taskid,dif_s,dif_us,
	debut.tv_sec-base_s,debut.tv_usec);
   buffer_index+=compactage(chaine,buffer+buffer_index);
		/* evenement marquant l'influence non negligeable de la
			sauvegarde */
   }
else
   buffer_index+=compactage(chaine,buffer+buffer_index);
		/* compactage et entree dans le buffer de l'evenement */
}

