#!/usr/bin/perl

# file     : mkpvmfmt.perl
# author   : Eric Maillet
# language : perl 4.0
# date     : december 1994

# mkpvmfmt.perl automatically generates the documentation of
# event formats.

# mkpvmfmt.perl uses the following files to do its job:
#
# - tape_reader.c, source code of the library
# - tape_header.doc, contains the textual header of the
#   documentation generated

# mkpvmfmt.perl generates the following output on stdout:
#
# first, the header in tape_header.doc
# then, the list of event formats taken from tape_reader.c

# generate header

open(h, "tape_header.doc") || die "Can't open tape_header.doc: $!\n";

while( <h> ) {
  print $_;
}

close(h);

# generate list of event formats
# note: special treatment for list fields which
#       are not explicitely named in macro calls
#       (delhosts,mcast,spawn)

open(f, "tape_reader.c") || die "Can't open tape_reader.c: $!\n";

$read = 0;

while( <f> ) {

  $read = 1 if /tape_read_event/;

  if( $read ) {

    if( /MKEVT\(([^\)]+)\);/ ) {
      printf("%3d    %-22s\n",0,$1);
    }

    if( /FMTEVT1\(([^,]+),([^\)]+)\);/ ) {
      printf("%3d    %-22s %s\n",1,$1,$2);
    }

    if( /[FMTEVT2|FMTGRPEVT2]\(([^,]+),([^,]+),([^\)]+)\);/ ) {
      if( $1 =~ /TapeDelhostsEvent/ ) {
        $n = 3;
        $list = " HostList";
      } else {
        $n=2;
	$list = "";
      }
      printf("%3d    %-22s %s\n",$n,$1,$2." ".$3.$list);
    }

    if( /[FMTEVT3|FMTGRPEVT3]\(([^,]+),([^,]+),([^,]+),([^\)]+)\);/ ) {
      if( $1 =~ /TapeSpawnEvent/ ) {
        $n = 4;
        $list = " TaskList";
      } else {
        $n=3;
	$list = "";
      }
      printf("%3d    %-22s %s\n",$n,$1,$2." ".$3." ".$4.$list);
    }

    if( /[FMTEVT4|FMTGRPEVT4]\(([^,]+),([^,]+),([^,]+),([^,]+),([^\)]+)\);/ ) {
      printf("%3d    %-22s %s\n",4,$1,$2." ".$3." ".$4." ".$5);
    }

    if( /[FMTEVT5|FMTGRPEVT5]\(([^,]+),([^,]+),([^,]+),([^,]+),([^,]+),([^\)]+)\);/ ) {
      printf("%3d    %-22s %s\n",5,$1,$2." ".$3." ".$4." ".$5." ".$6);
    }

    if( /[FMTEVT6|FMTGRPEVT6]\(([^,]+),([^,]+),([^,]+),([^,]+),([^,]+),([^,]+),([^\)]+)\);/ ) {
      if( $1 =~ /TapeMcastEvent/ ) {
        $n = 7;
        $list = " TaskList";
      } else {
        $n=6;
	$list = "";
      }
      printf("%3d    %-22s %s\n",$n,$1,$2." ".$3." ".$4." ".$5." ".$6." ".$7.$list);
    }

    if( /[FMTEVT7|FMTGRPEVT7]\(([^,]+),([^,]+),([^,]+),([^,]+),([^,]+),([^,]+),([^,]+),([^\)]+)\);/ ) {
      printf("%3d    %-22s %s\n",7,$1,$2." ".$3." ".$4." ".$5." ".$6." ".$7." ".$8);
    }

  }
}

close(f);
  