/* TAPE/PVM trace reader library */

/* $Log$ */

#ifndef _TAPE_READER_H_
#define _TAPE_READER_H_

#include <stdio.h>

  /**********************************
   * format of constant event header
   **********************************/

typedef struct {

  int type;
  int task;
  int file;
  int line;
  int date_s;
  int date_us;

} TapeEventHeader;

  /* some useful data structures before actual
   * event type definitions
   */

typedef int TapeTask;

typedef struct s_tasklist {

  TapeTask task;
  struct s_tasklist *next;

} * TapeTaskList;

typedef struct s_grouplist
{
  char group_name[80];
  TapeTaskList tasks;
  struct s_grouplist *next;
} *TapeGroupList;

typedef int TapeHost;

typedef struct s_hostlist {

  TapeHost host;
  struct s_hostlist *next;

} *TapeHostList;


typedef struct {

  TapeEventHeader header;

  int ret;

} TapeRetEvent;

typedef struct {

  TapeEventHeader header;

} TapeNullEvent;

  /****************************
   * format of pk, upk events
   ****************************/

typedef struct {

  TapeEventHeader header;

  int ret;
  int delta_s;
  int delta_us;
  int nitem;
  int stride;

} TapePkEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int delta_s;
  int delta_us;

} TapePk1Event;

typedef TapePkEvent TapeUpkEvent;
typedef TapePk1Event TapeUpk1Event;

  /***********************************
   * format of buffer handling events
   ***********************************/

typedef struct {

  TapeEventHeader header;

  int ret;
  int encoding;

} TapeMkbufEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int bufid;

} TapeFreebufEvent;

typedef TapeRetEvent TapeGetsbufEvent;

typedef TapeRetEvent TapeGetrbufEvent;

typedef TapeFreebufEvent TapeSetsbufEvent;

typedef TapeFreebufEvent TapeSetrbufEvent;

typedef TapeMkbufEvent TapeInitsendEvent;

  /***************************
   * format of control events 
   ***************************/

typedef TapeRetEvent TapeMytidEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  TapeTaskList TaskList;
  int flag;
  int ntask;

} TapeSpawnEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int tid;

} TapeKillEvent;

typedef TapeNullEvent TapeExitEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int what;
  int msgtag;
  int ntask;

} TapeNotifyEvent;

typedef TapeRetEvent TapeSendsigEvent;


  /*********************************
   * format of group related events
   *********************************/

typedef struct {

  TapeEventHeader header;

  int ret;
  char *group;
  int delta_s;
  int delta_us;
  int count;

} TapeBarrierEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  char *group;
  int tid;

} TapeGetinstEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  char *group;
  int delta_s;
  int delta_us;
  int msgtag;
  int bytes;

} TapeBcastEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  char *group;
  int inum;

} TapeGettidEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  char *group;

} TapeGsizeEvent;

typedef TapeGsizeEvent TapeJoingroupEvent;

typedef TapeGsizeEvent TapeLvgroupEvent;


  /****************************
   * pvm system related events
   ****************************/

typedef struct {

  TapeEventHeader header;

  int ret;
  int count;

} TapeAddhostsEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int what;

} TapeAdviseEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  TapeHostList HostList;
  int nhost;

} TapeDelhostsEvent;

typedef TapeKillEvent TapeTidtohostEvent;


  /*************************
   * message related events
   *************************/

typedef struct {

  TapeEventHeader header;

  int ret;
  int arrived;
  int delta_s;
  int delta_us;
  int tid;
  int msgtag;
  int bytes;

} TapeRecvEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int tid;
  int delta_s;
  int delta_us;
  int msgtag;
  int bytes;

} TapeSendEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  TapeTaskList TaskList;
  int delta_s;
  int delta_us;
  int msgtag;
  int bytes;
  int ntask;

} TapeMcastEvent;
 
typedef TapeSendEvent TapeNrecvEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int how;

} TapeSerrorEvent;

typedef TapeNullEvent TapeRecvfEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int tid;
  int msgtag;
  int bytes;

} TapeProbeEvent;


  /**************************
   * pvm info related events
   **************************/

typedef TapeRetEvent TapeParentEvent;

typedef TapeRetEvent TapeConfigEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int bufid;
  int bytes;
  int msgtag;
  int tid;

} TapeBufinfoEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int what;

} TapeGetoptEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int where;

} TapeTasksEvent;

typedef TapeKillEvent TapePstatEvent;

typedef TapeRetEvent TapePerrorEvent;


  /***************
   * other events
   ***************/

typedef TapeRetEvent TapeGetfdsEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int req;
  int data;

} TapeInsertEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int req;

} TapeDeleteEvent;

typedef TapeRetEvent TapeHaltEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int req;

} TapeLookupEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int mask;

} TapeSetdebugEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int block;

} TapeStart_pvmdEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  int narg;
  int nresp;

} TapeTickleEvent;

typedef TapeRetEvent TapeVersionEvent;


  /*************************************************************************
   * special, Tape specific events
   *
   * event_trace : delay of buffer flush in file (s) and number (us) fields
   *************************************************************************/

typedef TapeNullEvent TapeTraceEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  char *phase;

} TapeOpenPhaseEvent;

typedef TapeOpenPhaseEvent TapeClosePhaseEvent;

typedef struct {

  TapeEventHeader header;

  int ret;
  char *mask;

} TapeSetMaskEvent; 


  /************************
   * libtapereader globals
   ************************/

extern int TapeLine;
extern int TapeError;

#define TapeOK          0
#define TapeMallocError 1
#define TapeFileError   2




  /************************************
   * libtapereader function prototypes
   ************************************/

typedef struct s_trace {

  FILE* file;
  int line;

} *TapeTrace;

typedef TapeNullEvent TapeEvent;

#ifdef __ProtoGlarp__
#undef __ProtoGlarp__
#endif
#if defined(__STDC__) || defined(__cplusplus)
#define __ProtoGlarp__(x) x
#else
#define __ProtoGlarp__(x) ()
#endif

#ifdef __cplusplus
extern "C" {
#endif

TapeTrace tape_open_trace __ProtoGlarp__(( char* name ));
void tape_close_trace __ProtoGlarp__(( TapeTrace t ));
int tape_read_event __ProtoGlarp__(( TapeTrace t, TapeEvent **e ));
void tape_init_event __ProtoGlarp__(( TapeEvent **e ));
void tape_dispose_event __ProtoGlarp__(( TapeEvent **e ));
TapeTask tape_get_next_task __ProtoGlarp__(( TapeTaskList *tl ));
TapeHost tape_get_next_host __ProtoGlarp__(( TapeHostList *hl ));
unsigned tape_get_us __ProtoGlarp__(( int sec, int usec ));
double tape_get_s __ProtoGlarp__(( int sec, int usec ));
TapeTaskList tape_get_tasks_in_group __ProtoGlarp__(( char *group ));

#ifdef __cplusplus
}
#endif

#endif
