/* TAPE/PVM %W% %G% */

#include <sys/time.h>
#include <stdlib.h>

#include "pvm3.h"

#include "tape.h"
#include "tape_tags.h"

void tape_clock(struct timeval *);

void horloge_synchronisation (int nb_ping_pong)
{ 
int i,tid;
int sec,usec;
struct timeval tp;
 
tid=pvm_mytid();

for (i=0;i<nb_ping_pong;i++)
   { 
   pvm_initsend(PvmDataDefault);
   pvm_recv(pvm_parent(),msgtag_horl);
   tape_clock(&tp);
   sec=(int)tp.tv_sec;    /* we to this to be sure we use ints */
   usec=(int)tp.tv_usec;  /* on some systems the sec and usec fields are longs */
   pvm_pkint(&sec,1,1);
   pvm_pkint(&usec,1,1);
   pvm_send(pvm_parent(),msgtag_horl);
   }
pvm_exit();
}

void main(int argc, char **argv)
{ 
int nb_ping_pong;

nb_ping_pong=atoi(argv[1]);
horloge_synchronisation(nb_ping_pong);
}
  
